//
//  GraphicsViewControllerView.m
//  Rotating Shapes Drawn on Graphic Contexts
//
//  Created by Vandad Nahavandipoor on 17/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "GraphicsViewControllerView.h"

@implementation GraphicsViewControllerView

- (id)initWithFrame:(CGRect)frame{
  self = [super initWithFrame:frame];
  if (self) {
    //  Miejsce na kod inicjalizacyjny.
  }
  return self;
}

- (void)drawRect:(CGRect)rect{
  // Kod odpowiedzialny za rysowanie.
  
  /* Najpierw tworzymy ścieżkę. Pobieramy po prostu uchwyt do ścieżki. */
  CGMutablePathRef path = CGPathCreateMutable();
  
  /* To jest obszar ograniczający prostokąt. */
  CGRect rectangle = CGRectMake(10.0f,
                                10.0f, 
                                200.0f, 
                                300.0f);
  
  /* Obrót o 45 stopni zgodnie z kierunkiem ruchem wskazówek zegara. */
  CGAffineTransform transform = 
  CGAffineTransformMakeRotation((45.0f * M_PI) / 180.0f);
  
  /* Dodanie prostokąta do ścieżki. */
  CGPathAddRect(path, 
                &transform,
                rectangle);
  
  /* Pobranie uchwytu do bieżącego kontekstu graficznego. */
  CGContextRef currentContext = 
  UIGraphicsGetCurrentContext();
  
  /* Dodanie ścieżki do bieżącego kontekstu graficznego. */
  CGContextAddPath(currentContext,
                   path);
  
  /* Zdefiniowanie koloru wypełnienia: niebieski. */
  [[UIColor colorWithRed:0.20f
                   green:0.60f
                    blue:0.80f
                   alpha:1.0f] setFill];
  
  /* Zdefiniowanie koloru wypełnienia: brązowy. */
  [[UIColor brownColor] setStroke];
  
  /* Zdefiniowanie wartości 5 jako grubości linii ołówka. */
  CGContextSetLineWidth(currentContext, 
                        5.0f);
  
  /* Narysowanie i wypełnienie ścieżki w kontekście graficznym. */
  CGContextDrawPath(currentContext,
                    kCGPathFillStroke);
  
  /* Usunięcie ścieżki. */
  CGPathRelease(path);
  
}

@end
